/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.ntfy;

import com.ibm.hwmca.base.ntfy.NotificationConstants;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.HashMap;
import java.util.Map;

public class TemplateManagerPanelBean
extends PanelBean
implements NotificationConstants {
    private static final String TRACE_MASKT = "XNTYTMPT";
    private static final String TRACE_MASKF = "XNTYTMPF";
    private static final String TRACE_MASKD = "XNTYTMPD";
    private transient ItemDescriptor[] m_idTemplateTable;
    private transient ColumnDescriptor[] m_cdTemplateTableStructure;
    private int[] m_iTemplateTableSelection;
    private Map data;
    public static final String TEMPLATE_TABLE = "TemplateTable";
    public static final String TASKLET_SELECTED_TEMPLATE = "TaskletSelectedTemplate";

    public void setTemplateTableSelection(int[] selected) throws IllegalUserDataException {
        if (selected != null && selected.length > 0) {
            this.userTaskManager.setEnabled(this.getMountPrefix() + "EditButton", true);
            this.userTaskManager.setEnabled(this.getMountPrefix() + "DeleteButton", true);
        } else {
            this.userTaskManager.setEnabled(this.getMountPrefix() + "EditButton", false);
            this.userTaskManager.setEnabled(this.getMountPrefix() + "DeleteButton", false);
        }
        this.m_iTemplateTableSelection = selected;
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "-> panelAction()");
        String command = event.getActionCommand();
        PanelTaskletRequest request = new PanelTaskletRequest(this.getClass().getName() + this.getMountPrefix());
        request.setData("CommandSource", "TemplateManagerPanel");
        String template = null;
        Map[] templatesMap = (Map[])this.data.get(TEMPLATE_TABLE);
        template = this.m_iTemplateTableSelection != null && this.m_iTemplateTableSelection.length > 0 ? (String)templatesMap[this.m_iTemplateTableSelection[0]].get("DataMapName") : "";
        if (command.equals(this.getMountPrefix() + "OKButton")) {
            request.setData(TASKLET_SELECTED_TEMPLATE, template);
            request.setData("CommandName", "OKButton");
        } else if (command.equals(this.getMountPrefix() + "AddButton")) {
            request.setData("CommandName", "AddButton");
        } else if (command.equals(this.getMountPrefix() + "EditButton")) {
            if (template.equals("")) {
                request = null;
            } else {
                request.setData("CommandName", "EditButton");
                request.setData(TASKLET_SELECTED_TEMPLATE, template);
            }
        } else if (command.equals(this.getMountPrefix() + "DeleteButton")) {
            if (template.equals("")) {
                request = null;
            } else {
                request.setData("CommandName", "DeleteButton");
                request.setData(TASKLET_SELECTED_TEMPLATE, template);
            }
        }
        if (request != null) {
            this.postTaskletRequest(request);
        }
        Trace.trace(TRACE_MASKT, "<- panelAction()");
    }

    public void update(Object o) {
        Trace.trace(TRACE_MASKT, "<> update");
        if (o instanceof Map) {
            Map map = (Map)o;
            String command = (String)map.get("CommandName");
            Map[] templates = (Map[])this.data.get(TEMPLATE_TABLE);
            if (command.equals("DeleteButton")) {
                Map[] newTemplates = new Map[templates.length - 1];
                System.arraycopy(templates, 0, newTemplates, 0, this.m_iTemplateTableSelection[0]);
                System.arraycopy(templates, this.m_iTemplateTableSelection[0] + 1, newTemplates, this.m_iTemplateTableSelection[0], newTemplates.length - this.m_iTemplateTableSelection[0]);
                this.data.put(TEMPLATE_TABLE, newTemplates);
                this.userTaskManager.setSelectedRows(this.getMountPrefix() + TEMPLATE_TABLE, new int[0]);
                this.setTemplateTableSelection(new int[0]);
            } else if (command.equals("AddButton")) {
                Map[] newTemplates = new Map[templates.length + 1];
                System.arraycopy(templates, 0, newTemplates, 0, templates.length);
                HashMap newTemplate = new HashMap();
                newTemplate.put("DataMapName", map.get("DataMapName"));
                newTemplate.put("DataMapDesc", map.get("DataMapDesc"));
                newTemplates[templates.length] = newTemplate;
                this.data.put(TEMPLATE_TABLE, newTemplates);
            } else if (command.equals("EditButton")) {
                templates[this.m_iTemplateTableSelection[0]].put("DataMapName", map.get("DataMapName"));
                templates[this.m_iTemplateTableSelection[0]].put("DataMapDesc", map.get("DataMapDesc"));
            }
            this.userTaskManager.refreshAllElements();
        }
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<> verifyChanges()");
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "<> save()");
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> prepare()");
        String selectedTemplate = (String)this.data.get(TASKLET_SELECTED_TEMPLATE);
        int selectedTemplateIndex = -1;
        Map[] templates = (Map[])this.data.get(TEMPLATE_TABLE);
        if (templates != null) {
            for (int i = 0; i < templates.length; ++i) {
                if (templates[i] == null || selectedTemplate == null || !selectedTemplate.equals((String)templates[i].get("DataMapName"))) continue;
                selectedTemplateIndex = i;
            }
            if (selectedTemplateIndex >= 0) {
                this.userTaskManager.setSelectedRows(this.getMountPrefix() + TEMPLATE_TABLE, new int[]{selectedTemplateIndex});
                this.m_iTemplateTableSelection = new int[]{selectedTemplateIndex};
            } else {
                this.userTaskManager.setEnabled(this.getMountPrefix() + "EditButton", false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DeleteButton", false);
            }
        } else {
            this.data.put(TEMPLATE_TABLE, new Map[0]);
        }
        Trace.trace(TRACE_MASKT, "<- prepare()");
    }

    public void load() {
        this.m_idTemplateTable = new ItemDescriptor[0];
        this.m_cdTemplateTableStructure = new ColumnDescriptor[0];
        this.m_iTemplateTableSelection = new int[0];
        if (this.data == null) {
            this.data = new HashMap();
        }
    }

    public void setData(Map data) {
        this.data = data;
    }

    public int getTemplateTableRowCount() {
        Map[] templates = (Map[])this.data.get(TEMPLATE_TABLE);
        return templates.length;
    }

    public ItemDescriptor[] getTemplateTableRowAt(int index) {
        Map[] templates = (Map[])this.data.get(TEMPLATE_TABLE);
        ItemDescriptor col1 = new ItemDescriptor(this.getMountPrefix() + "name_" + index, (String)templates[index].get("DataMapName"));
        ItemDescriptor col2 = new ItemDescriptor(this.getMountPrefix() + "desc_" + index, (String)templates[index].get("DataMapDesc"));
        return new ItemDescriptor[]{col1, col2};
    }

    public ColumnDescriptor[] getTemplateTableRowStructure() {
        return this.m_cdTemplateTableStructure;
    }

    public int getTemplateTableRowStatus() {
        return 3;
    }

    public void setTemplateTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idTemplateTable = items;
    }

    public int[] getTemplateTableSelection() {
        return this.m_iTemplateTableSelection;
    }
}

